#!/usr/bin/python

#
#  CC0 2011, Martin Haye
#
#  To the extent possible under law, Martin Haye has waived all copyright 
#  and related or neighboring rights to p2e: Pseudo-II Emulator. 
#  This work is published from: United States.
#

import cgitb; cgitb.enable()  # for troubleshooting

import cgi, gzip, re, shutil, StringIO, sys, urllib, urllib2, zipfile;

from os.path import basename
from urlparse import urlsplit

form = cgi.FieldStorage()
target = form.getvalue("target");

# Switch to HTTP mirror if possible
target = target.replace("ftp://ftp.apple.asimov.net/", "http://mirrors.apple2.org.za/ftp.apple.asimov.net/")
assert not target.startswith("ftp:")

def url2name(url):
  return basename(urlsplit(url)[2])

def getLocalName(url, r):
  localName = url2name(url)
  if r.info().has_key('Content-Disposition'):
    # If the response has Content-Disposition, we take file name from it
    localName = r.info()['Content-Disposition'].split('filename=')[1]
    if localName[0] == '"' or localName[0] == "'":
      localName = localName[1:-1]
  elif r.url != url: 
    # if we were redirected, the real file name we take from the final URL
    localName = url2name(r.url)
  return localName
  
# For some reason urllib2 in Python 2.5 doesn't work right with spaces
target = target.replace(" ", "%20")

# Send the request
req = urllib2.Request(target)
r = urllib2.urlopen(req)

# limit to disk images and smaller
assert int(r.info()['Content-Length']) <= 140*1024
filedata = r.read()

# If the data is compressed, decompress it.
localName = getLocalName(target, r)
if re.match(".*\.gz$", localName, re.IGNORECASE):
  filedata = gzip.GzipFile(fileobj = StringIO.StringIO(filedata)).read()
elif re.match(".*\.zip$", localName, re.IGNORECASE):
  zf = zipfile.ZipFile(StringIO.StringIO(filedata), "r")
  for info in zf.infolist():
    if info.file_size == 140*1024:
      filedata = zf.read(info.filename)

# Result after decompression must be exactly 140k (or a 32k rom image)
assert len(filedata) == 140*1024 or len(filedata) == 32*1024

# Copy the content type, if applicable  
if r.info().has_key('Content-Type'):
  print "Content-Type: %s\n" % r.info()['Content-Type']

# And spit out the data.
sys.stdout.write(filedata)

r.close()
